<?php

namespace App\Console\Commands;

use App\Entities\Area;
use App\Entities\Persona;
use App\Entities\Sede;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class HappyBirthday extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:birthday {id?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envió e-mail saludando al personal por su cumpleaños.';

    /**
     * HappyBirthday constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $dateMonth = date('m');
        $id = $this->argument('id');
        if ($id == null) {
            $personas = Persona::select('*', DB::raw('DAY(fecha_nacimiento) as dateDay'))
                ->whereNull('deleted_at')
                ->whereMonth('fecha_nacimiento', '=', $dateMonth)
                ->orderBy('dateDay')
                ->get();

//            $emails = ['administrador@almoperations.com', 'jcalderon@cableperu.net', 'kponte@cableperu.net', 'lromero@cableperu.net', 'bcrisostomo@cableperu.net', 'kabanto@cableperu.net'];
            $emails = ['everyonecvp@cableperu.net', 'everyoneGTC@cableperu.net', 'everyoneutv@cableperu.net'];

            foreach ($personas as $key => $persona) {
                if (verificaCumple($persona->fecha_nacimiento)) {
                    $personas[$key]['area'] = Area::find($persona->cargo->area_id);
                    $personas[$key]['sede'] = Sede::find($persona->area->sede_id);
                    $data = [];
                    $data['apellidos_nombres'] = $persona->apellidos_nombres;
                    $data['cargo'] = $persona->cargo->nombre;
                    $data['filial'] = $persona->sede->nombre;
                    if ($persona->foto != null) {
//                        $data['foto'] = asset('web/perfil/thumbnail/thumb-' . $persona->foto);
                        $data['foto'] = "https://dircorp.cableperu.net.pe/web/perfil/thumbnail/thumb-" . $persona->foto;
                    }
                    Mail::send('superadmin.herramientas.email.cumpleanio', $data, function ($message) use ($persona, $emails) {
                        $message->from('comunicaciones@cableperu.net', 'Comunicaciones');
                        $message->to($emails);
                        $message->subject('🎂 🎉 🍰 🎊 FELIZ CUMPLEAÑO ' . $persona->apellidos_nombres);
                    });
                    $this->info('Los mensajes de felicitacion han sido enviados correctamente');
                }
            }
        } else {
            $persona = Persona::select('*', DB::raw('DAY(fecha_nacimiento) as dateDay'))
                ->whereNull('deleted_at')
                ->whereMonth('fecha_nacimiento', '=', $dateMonth)
                ->where('id', $id)
                ->orderBy('dateDay')
                ->first();
//            $emails = ['administrador@almoperations.com', 'jcalderon@cableperu.net', 'kponte@cableperu.net', 'lromero@cableperu.net', 'bcrisostomo@cableperu.net', 'kabanto@cableperu.net'];
            $emails = ['everyonecvp@cableperu.net', 'everyoneGTC@cableperu.net', 'everyoneutv@cableperu.net'];
            if (verificaCumple($persona->fecha_nacimiento)) {
                $areaPersona = Area::find($persona->cargo->area_id);
                $sedePersona = Sede::find($areaPersona->sede_id);
                $data = [];
                $data['apellidos_nombres'] = $persona->apellidos_nombres;
                $data['cargo'] = $persona->cargo->nombre;
                $data['filial'] = $sedePersona->nombre;
                if ($persona->foto != null) {
//                    $data['foto'] = asset('web/perfil/thumbnail/thumb-' . $persona->foto);
                    $data['foto'] = "https://dircorp.cableperu.net.pe/web/perfil/thumbnail/thumb-" . $persona->foto;
                }
                Mail::send('superadmin.herramientas.email.cumpleanio', $data, function ($message) use ($persona, $emails) {
                    $message->from('comunicaciones@cableperu.net', 'Comunicaciones');
                    $message->to($emails);
                    $message->subject('🎂 🎉 🍰 🎊 FELIZ CUMPLEAÑO ' . $persona->apellidos_nombres);
                });
                $this->info('El mensaje de felicitacion fue enviado correctamente');
            }
        }
    }
}
